﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;

using GE.World;
using GE.Manager;

namespace GE.Gui
{
    /// <summary>
    /// the credit window
    /// </summary>
    class WCreditWindow : Window
    {
        /// <summary>
        /// Background image
        /// </summary>
        WImage _background;

        /// <summary>
        /// Title
        /// </summary>
        WText _title;

        /// <summary>
        /// Button to go back to the main menu
        /// </summary>
        WButton _buttonBack;

        public WCreditWindow()
        {
            
            _background = new WImage("Widget\\creditBackground", Vector2.Zero);
            _title = new WText(FontType.MenuTitle, "Credit", new Vector2(Visualisation.Visu.Instance.ScreenWidth/2 - 90, 30), Color.RosyBrown);
            _buttonBack = new WButton(this, "Back", Color.RosyBrown, new Vector2(500, 400));

            WText _line1 = new WText(FontType.MenuButton, "Programmer : Florent DEVILLE", new Vector2(50, 90), Color.White);

            WText _line3 = new WText(FontType.MenuButton, "www.flodeville.com", new Vector2(100, 120), Color.White);
            WText _line2 = new WText(FontType.MenuButton, "florent.devillechabrol@gmail.com", new Vector2(100, 150), Color.White);
            WText _line4 = new WText(FontType.MenuButton, "Art : Everything belongs to Capcom.", new Vector2(50, 330), Color.White);

            addWidget(_background);
            addWidget(_title);
            addWidget(_buttonBack);
            addWidget(_line1);
            addWidget(_line2);
            addWidget(_line3);
            addWidget(_line4);

            registerButton(_buttonBack, null, null, null, null);

            _buttonBack.OnClick = GetType().GetMethod("onClose");
        }
    }
}
